#include "ImageReader.cpp"
#include "IWriterStrategy.h"
#include "BMPWriterStrategy.h"
#include <iostream>
#include <memory>

int main(int argc, char* argv[]) {
    if (argc != 2) {
        std::cerr << "Usage: " << argv[0] << " <ana_file_path>" << std::endl;
        return 1;
    }
    
    std::string filePath = argv[1]; 

    try {
        ImageReader reader;
        ImageData imageData = reader.readAndSeparateChannels(filePath); 
        
        std::unique_ptr<IWriterStrategy> writerStrategy = std::make_unique<BMPWriterStrategy>();
        std::vector<uint8_t> bmp = writerStrategy->write(imageData);
        std::cout.write(reinterpret_cast<const char*>(bmp.data()), bmp.size());

    } catch (const std::runtime_error& e) {
        std::cerr << e.what() << std::endl;
        return 1;
    } catch (...) {
        std::cerr << "[Error] 유효한 입력이 아닙니다." << std::endl;
        return 1;
    }

    return 0;
}
