# RLEANA

## 1. 문제

### 1.1 문제 상황
ANA의 홍보부장 하은이는 효율적인 이미지 관리를 위해 새로운 포맷 **ana**(ANIGMA Native Artwork)를 만들었다. 다음 표는 **ana** 포맷의 섹션 별 크기, 자료형과 설명을 보여준다.

| 섹션 | 크기 | 자료형 | 설명 |
| :--- | :--- | :--- | :--- |
| **Signature** | $4$ Bytes | `uint32_t` | 매직 넘버: `0x414E4100` ("ANA\0") |
| **Width** | $2$ Bytes | `int16_t` | 이미지 너비 (픽셀) |
| **Height** | $2$ Bytes | `int16_t` | 이미지 높이 (픽셀) |
| **Data Stream** | $4\times N$ Bytes | `uint8_t` | RLE Chunk (N, R, G, B)의 시퀀스 |

**Signature**은 `Big Endian`으로 `ANA\0`와 같다.  
**Width**와 **Height**는 `Little Endian`이다. Width와 Height의 곱은 이미지의 총 픽셀 수를 나타낸다. 이미지의 크기가 매우 커지는 것을 방지하기 위해 각각 **최대 $32767$ 픽셀**로, 또 $Width\times Height$는 **최대 $3,400,000$ 픽셀**(약 10MB)로 제한한다.  
**Data Stream**은 이미지 전체 픽셀을 순서대로 저장한 **RLE(Run-Length Encoding)** 방식의 압축된 **RLE Chunk** 바이트 시퀀스이다. 각 RLE Chunk는 4바이트로 구성된다. 다음 표는 RLE Chunk의 필드 별 크기, 자료형과 설명을 보여준다.

| 필드    | 크기     | 자료형       | 설명                      |
| ----- | ------ | --------- | ----------------------- |
| **N** | $1$ Byte | `uint8_t` | 반복 횟수 (이 청크가 나타내는 픽셀 수) |
| **R** | $1$ Byte | `uint8_t` | Red 값 (0–255)           |
| **G** | $1$ Byte | `uint8_t` | Green 값 (0–255)         |
| **B** | $1$ Byte | `uint8_t` | Blue 값 (0–255)          |  

**RLE Chunk** `(N, R, G, B)`의 의미는 다음과 같다.  
- RGB 색상 (R, G, B)인 픽셀을 **N개 연속**으로 출력한다.  
(예시) `03 FF 00 00` → (`FF 00 00`) 픽셀 3개.

**Data Stream**의 범위는 다음과 같은 제약 조건을 가진다.
* RLE Chunk는 $Width\times Height$ 만큼의 픽셀이 재구성될 때까지 지속된다.
* 총 픽셀 수를 넘어서 주어지는 데이터는 무시된다. 

하은이는 **ana** 파일을 입력받아서 BMP 파일로 변환하는 프로그램을 작성했다. 이 프로그램은 먼저 **ana** 파일을 디코딩하여 RGB 픽셀 스트림을 얻은 후, 이를 BMP 형식으로 변환한다.  
그러나, 이 프로그램에는 결함이 있어 사용을 못하고 있다. 여러분은 하은이를 위해 프로그램의 결함을 해결해주자.

### 1.2 입력
**ana** 포맷의 파일이 입력으로 주어진다.

### 1.3 출력
BMP 파일의 바이트 시퀀스를 표준 출력으로 출력한다.

### 1.4 입력 예시
sample.ana

### 1.5 출력 예시
```
BMZ6($

      ���������������
```
sample.bmp

---

## 2. 평가 테스크

제공된 코드에는 **실행 중 오류** 또는 **논리적 결함**이 내장되어 있다.  

### Task1 결함 유발 입력값 찾기 (Bug Hunting)

제공된 코드의 결함으로 인해 비정상적인 동작을 유발하는 입력을 찾아 제출해야 한다.

### Task2 결함 코드 수정하기 (Patch)

**Task1**에서 발견하거나 추정한 결함을 해결하기 위해 **제공된 코드 파일을 수정**해야 한다.  
목표는 제한 범위 내 모든 입력에 대해 **정확한 값**을 계산하여 출력하도록 수정해야 한다.  
**※** `ANABuilder.py`**는 별도로 제공되는 코드로, Task2 편집거리 계산에 포함되지 않는다.**  

-----

## 3. 참고

### 3.1 디자인 패턴
프로그램은 **전략(Strategy) 패턴**을 사용하여 다양한 출력 포맷으로의 변환을 유연하게 교체할 수 있도록 설계되어 있다.
  * `main.cpp`: 실행 진입점 및 출력 담당
  * `ImageData.h`: Width, Height, RGB 채널 데이터를 포함하는 이미지 데이터 구조 정의
  * `ANADecoder.h/cpp`: RLE 압축 해제 로직을 구현한 디코더
  * `ImageReader.cpp`: 파일 헤더 파싱 및 RGB 채널 데이터 분리 담당
  * `IWriterStrategy.h`: 다양한 출력 포맷 변환을 위한 공통 인터페이스 정의
  * `BMPWriterStrategy.h/cpp`: BMP 형식으로 이미지 데이터를 변환하는 구체적인 전략 클래스

### 3.2 테스트 ana 파일 생성
테스트용 `ana` 파일 생성을 위한 방법으로는 대표적으로 2가지가 있다.
1. 바이너리 편집 도구(예시, `HxD`)를 사용한다. 이 때, `Big Endian`, `Little Endian` 혼용에 주의한다.
2. `ANABuilder.py`는 `ana` 파일 생성을 돕기 위해 제공되는 구현체로, 문제 해결을 위한 분석은 불필요하다.  
**빌더(Builder) 패턴**을 통해 테스트용 바이너리 파일 생성 과정을 단계적으로 처리한다.  
제공된 파일은 `sample.ana` 를 생성하는 코드이다.  

### 3.3 Writer Strategy
`BMPWriterStrategy` 클래스는 `IWriterStrategy` 인터페이스를 구현하여 ImageData를 BMP 형식으로 변환하는 기능을 제공한다.  
전략 패턴을 통해 다양한 출력 포맷(PNG, JPEG 등)을 쉽게 확장할 수 있으며, 이를 통해 디코딩된 이미지를 시각적으로 확인할 수 있다.  
또한, 이는 출력을 돕기 위한 구현체로 문제 해결을 위한 분석은 불필요하다.  
만약 `BMPWriterStrategy` 코드에 결함이 있다고 판단될 경우, 수정하여도 무방하다.  
다음은 make run을 응용하여 BMP 파일을 생성하는 예시이다.
```
make run file=sample.ana > sample.bmp
```

### 3.4 첨부 파일 설명
아래는 제공된 `sample.ana` 파일을 `HxD`를 통해 구조화한 이미지이다.  

<img src="RLEANA.png">   

아래는 제공된 `sample.ana` 파일을 BMP 파일로 변환한 `sample.bmp` 이다.  

<img src="sample.bmp">

---