#include "ImageData.h"
#include "ANADecoder.h"
#include <fstream>
#include <stdexcept>
#include <iostream>
#include <cstdint>

class ImageReader {
public:
    ImageData readAndSeparateChannels(const std::string& filePath) const {
        std::ifstream file(filePath, std::ios::binary);
        if (!file.is_open()) {
            throw std::runtime_error("[Error] 유효한 입력이 아닙니다.");
        }

        uint32_t signature;
        int16_t width, height;

        if (!file.read((char*)&signature, 4) ||
            !file.read((char*)&width, 2) ||
            !file.read((char*)&height, 2)) {
            throw std::runtime_error("[Error] 유효한 입력이 아닙니다.");
        }
        
        if (signature != 0x414e41) {
            throw std::runtime_error("[Error] 유효한 입력이 아닙니다.");
        }
        
        if (width <= 0 || height <= 0 || width * height > 3400000) { // Verify if width and height are too large
            throw std::runtime_error("[Error] 유효한 입력이 아닙니다.");
        }

        uint16_t totalPixels = width * height;
        
        std::vector<uint8_t> rgbStream = ANADecoder::decode(file, totalPixels);

        ImageData result;
        result.width = width;
        result.height = height;
        result.R.reserve(totalPixels);
        result.G.reserve(totalPixels);
        result.B.reserve(totalPixels);

        for (uint16_t i = 0; i < totalPixels; ++i) {
            result.R.push_back(rgbStream[i * 3 + 0]);
            result.G.push_back(rgbStream[i * 3 + 1]);
            result.B.push_back(rgbStream[i * 3 + 2]);
        }
        
        return result;
    }
};
