#include "ANADecoder.h"
#include <iostream>
#include <stdexcept>
#include <cstdint>
#include <vector>

std::vector<uint8_t> ANADecoder::decode(std::istream& fileStream, uint16_t totalPixels) {
    std::vector<uint8_t> decodedData;
    
    uint16_t pixelsDecoded = 0; 
    
    uint8_t count, r, g, b;

    while (fileStream.peek() != EOF && pixelsDecoded < totalPixels) {
        
        if (!(fileStream.read((char*)&count, 1))) break;
        
        if (!(fileStream.read((char*)&r, 1) &&
              fileStream.read((char*)&g, 1) &&
              fileStream.read((char*)&b, 1))) {
            throw std::runtime_error("[Error] 유효한 입력이 아닙니다.");
        }

        for (uint8_t i = 0; i < count; ++i) {
            
            if (pixelsDecoded >= totalPixels) break;
            
            decodedData.push_back(r);
            decodedData.push_back(g);
            decodedData.push_back(b);
            
            pixelsDecoded++; 
        }
    }

    if (pixelsDecoded != totalPixels) {
        throw std::runtime_error("[Error] 유효한 입력이 아닙니다.");
    }
    
    return decodedData;
}

