#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <vector>
#include <cctype>
#include <climits>
#include <cstdlib>

#include "UnitFactory.h"
#include "SceneManager.h"

const std::string CMD_SPAWN = "SPAWN";
const std::string CMD_RENDER = "RENDER";

int main(int argc, char* argv[]) {
    if (argc < 2) {
        std::cerr << "Usage: " << argv[0] << " <input_file>" << std::endl;
        return 1;
    }

    std::string inputFilePath = argv[1];
    std::ifstream inputFile(inputFilePath);

    if (!inputFile.is_open()) {
        std::cerr << "[Error] 유효한 입력이 아닙니다." << std::endl;
        return 1;
    }

    SceneManager scene;
    std::string line;

    while (std::getline(inputFile, line)) {
        if (line.empty()) continue;

        std::stringstream ss(line);
        std::string command;
        ss >> command;

        if (command == CMD_SPAWN) {
            int typeId;
            std::string name;
            std::string typeIdStr;
            
            if (!(ss >> typeIdStr)) {
                std::cerr << "[Error] 유효한 입력이 아닙니다." << std::endl;
                return 1;
            }
            
            bool isValidNumber = true;
            if (typeIdStr.empty()) {
                isValidNumber = false;
            } else {
                size_t startIdx = 0;
                if (typeIdStr[0] == '+' || typeIdStr[0] == '-') {
                    startIdx = 1;
                    if (typeIdStr.length() == 1) {
                        isValidNumber = false;
                    }
                }
                
                if (isValidNumber) {
                    for (size_t i = startIdx; i < typeIdStr.length(); i++) {
                        if (!std::isdigit(typeIdStr[i])) {
                            isValidNumber = false;
                            break;
                        }
                    }
                }
            }
            
            if (!isValidNumber) {
                std::cerr << "[Error] 유효한 입력이 아닙니다." << std::endl;
                return 1;
            }
            
            long long typeIdLong = std::strtoll(typeIdStr.c_str(), nullptr, 10);
            
            if (typeIdLong < INT_MIN || typeIdLong > INT_MAX) {
                std::cerr << "[Error] 유효한 입력이 아닙니다." << std::endl;
                return 1;
            }
            
            typeId = static_cast<int>(typeIdLong);
            
            if (ss >> name) {
                bool isValidName = true;
                
                if (name.length() < 1 || name.length() > 20) {
                    isValidName = false;
                } else {
                    for (char c : name) {
                        if (!std::isalnum(c)) {
                            isValidName = false;
                            break;
                        }
                    }
                }
                
                if (!isValidName) {
                    std::cerr << "[Error] 유효한 입력이 아닙니다." << std::endl;
                    return 1;
                }
                
                IGameObject* newUnit = UnitFactory::createUnit(typeId, name);
                
                if (newUnit != nullptr) {
                    scene.addUnit(newUnit);
                } else {
                    std::cerr << "[Error] 유효한 입력이 아닙니다." << std::endl;
                    return 1;
                }
            } else {
                std::cerr << "[Error] 유효한 입력이 아닙니다." << std::endl;
                return 1;
            }
        } 
        else if (command == CMD_RENDER) {
            scene.renderScene();
        }
        else {
            std::cerr << "[Error] 유효한 입력이 아닙니다." << std::endl;
            return 1;
        }
    }

    inputFile.close();
    return 0;
}