// SceneManager.cpp
#include "SceneManager.h"
#include "./RenderPipeline.h"
#include <iostream>

SceneManager::~SceneManager() {
    for (IGameObject* unit : activeUnits) {
        delete unit;
    }
    activeUnits.clear();
}

void SceneManager::addUnit(IGameObject* unit) {
    activeUnits.push_back(unit);
    std::cout << "[Manager] Unit registered: " << unit->getName() << std::endl;
}

void SceneManager::renderScene() {
    std::cout << "\n--- [Server] Rendering Started ---" << std::endl;
    
    for (IGameObject* unit : activeUnits) {
        RenderPipeline::processAndDraw(*unit);
    }
    
    std::cout << "--- [Server] Rendering Finished ---\n" << std::endl;
}