# RENDERING 

## 1. 문제

### 1.1 문제 상황
게임 개발사 'Hexagon Games'는 차세대 텍스트 RPG인 'Hexagon Chronicles'의 출시를 앞두고 있다. 그래픽 팀은 각 캐릭터의 개성을 살리기 위해 `Paladin`의 `Golden Aura`와 `Wizard`의 `Arcane Sparkles` 이펙트를 공들여 구현했다.

어느 날, QA(품질 보증) 팀으로부터 'Hexagon Chronicles'에 대한 'Critical' 등급의 버그 리포트가 개발팀 강준이를 통해 접수되었다. 리포트의 제목은 정상이지만 본문의 내용이 손상되어 도착했다. 안타깝게도 QA팀의 전원이 퇴근하여 강준이는 발을 동동 구르는 상황이다. 여러분은 강준이의 빠른 퇴근을 위해 버그 리포트의 해결을 도와주자.

### 1.2 입력
여러 줄에 걸쳐 각 줄마다 다음 두 가지 형식 중 하나가 주어진다.

1. `SPAWN <type_id> <name>`
   - 새로운 유닛을 생성하여 씬(Scene)에 추가한다.
   - $type\_id$는 정수이며, int형 범위 내의 값이어야 한다. $1$은 **Paladin**, $2$는 **Wizard**, 그 외는 **Default**를 의미한다.
   - $name$은 유닛의 이름을 나타내는 문자열이다. 이름은 영문 대소문자와 숫자로만 구성되며, 공백을 포함하지 않는다 $(1 \leq |name| \leq 20)$

2. `RENDER`
   - 현재 씬에 존재하는 모든 유닛을 생성된 순서대로 렌더링한다.

### 1.3 출력
각 명령어에 대해 다음과 같이 출력한다.

1. `SPAWN` 명령 수행 시:
   - `[Manager] Unit registered: <name>` 형식으로 등록 확인 메시지를 출력한다.

2. `RENDER` 명령 수행 시:
   - 첫째 줄에 `--- [Server] Rendering Started ---`를 출력한다.
   - 모든 유닛에 대해 렌더링 직전에 `(Pipeline) Calculating lighting...`를 출력한다.
   - 모든 유닛에 대해 렌더링 시 각 클래스 고유의 메시지를 출력한다.
     - **Paladin**: `>>> [Paladin] <name> appears with Golden Aura!`
     - **Wizard**: `*** [Wizard] <name> casts Arcane Sparkles!`
     - **Default**: `### [Default] <name> has been spawned.`
   - 마지막 줄에 `--- [Server] Rendering Finished ---`를 출력한다.

모든 출력 문자열의 공백과 특수문자는 예시와 일치해야 한다.

### 1.4 입력 예시
```
SPAWN 0 Steve
SPAWN 0 Villager
RENDER
```

### 1.5 출력 예시
```
[Manager] Unit registered: Steve
[Manager] Unit registered: Villager

--- [Server] Rendering Started ---
(Pipeline) Calculating lighting...
### [Default] Steve has been spawned.
(Pipeline) Calculating lighting...
### [Default] Villager has been spawned.
--- [Server] Rendering Finished ---
```

---

## 2. 평가 테스크

제공된 코드에는 **실행 중 오류** 또는 **논리적 결함**이 내장되어 있다.  

### Task1 결함 유발 입력값 찾기 (Bug Hunting)

제공된 코드의 결함으로 인해 비정상적인 동작을 유발하는 입력을 찾아 제출해야 한다.

### Task2 결함 코드 수정하기 (Patch)

**Task1**에서 발견하거나 추정한 결함을 해결하기 위해 **제공된 코드 파일을 수정**해야 한다.  
목표는 제한 범위 내 모든 입력에 대해 **정확한 값**을 계산하여 출력하도록 수정해야 한다.

-----

## 3. 참고

### 3.1 디자인 패턴
프로그램은 **팩토리 메서드(Factory Method) 패턴**을 사용하여 유닛 생성 로직을 분리하고, **매니저(Manager) 패턴**을 통해 씬(Scene) 내 객체들을 관리한다.
  * `main.cpp`: 실행 진입점
  * `UnitFactory.cpp`: `Paladin`, `Wizard` 등의 유닛 생성 로직 구현
  * `SceneManager.cpp`: 유닛 객체의 저장 및 생명주기 관리
  * `RenderPipeline.cpp`: 렌더링 실행 흐름 담당

---