import sys
from sender import create_alert, send_alert

def main():
    input_file = sys.argv[1] if len(sys.argv) > 1 else 'sample.in'
    
    try:
        with open(input_file, 'r', encoding='utf-8') as f:
            lines = f.readlines()
    except FileNotFoundError:
        print(f"[Error] 유효한 입력이 아닙니다.")
        return

    for line in lines:
        line = line.strip()
        if not line: continue

        parts = line.split('|')
        message = parts[0].strip()
        
        if len(parts) > 1:
            tag_input = parts[1].strip()
            if not tag_input.isalpha() or tag_input == "System":
                print("[Error] 유효한 입력이 아닙니다.")
                sys.exit(1)
            alert = create_alert(message, tags=[tag_input])
        else:
            alert = create_alert(message)

        send_alert(alert)

if __name__ == "__main__":
    main()