# SLACK

## 1. 문제

### 1.1 문제 상황  
ANA 마트의 총무인 현성이는 보다 효율적인 업무 관리를 위해 Slack의 웹훅으로 봇을 활용한 알림 발송 자동화 프로그램을 구상하여 개발 담당 민우에게 업무를 할당했다. 민우는 봇과 자동화에 유리한 파이썬을 기반으로 코드를 작성하여 성공적으로 배포했다.  
이 시스템은 알림 생성 시 기본적으로 `['System']` 이란 **기본 태그**를 자동으로 부착하여 관리자에게 전송하도록 설계되어 있다.  
`System` 태그는 관리자만 사용 가능한 기본 태그이므로 사용자는 해당 태그를 직접 사용할 수 없다.  
사용자가 별도의 태그를 지정하면 **기본 태그**에 추가로 사용자의 태그를 부착한다.

어느 날 민우는 프로그램에 결함이 발생했다는 모종의 이유로 현성이에게 불려 가 꾸중을 들었다.  
여러분은 민우가 더 이상 꾸중을 듣지 않도록 그 이유를 찾고 수정하여 민우를 도와주자.

### 1.2 입력  
여러 줄에 걸쳐 `메시지 내용` 또는 `메시지 내용 | 태그` 가 주어진다.  
태그는 영문 대소문자(`[a-zA-Z]`)로만 구성되어야 한다.  
단, `System` 태그는 관리자 전용 기본 태그이므로 사용자가 직접 입력할 수 없다.  

### 1.3 출력
각 알림이 전송될 때마다 발송자, 메시지 그리고 부착된 태그 목록을 출력한다.  
출력은 예시와 같은 형식이다.  

### 1.4 입력 예시
```
Good morning everyone
Emergent security issues | Emergency
Starting server maintenance | Notification
Server maintenance completed | Notification
```

### 1.5 출력 예시
```
>> [Bot] Good morning everyone / Tags: ['System']
>> [Bot] Emergent security issues / Tags: ['Emergency', 'System']
>> [Bot] Starting server maintenance / Tags: ['Notification', 'System']
>> [Bot] Server maintenance completed / Tags: ['Notification', 'System']
```

---

## 2. 평가 테스크

제공된 코드에는 **논리적 결함**이 내장되어 있다.  
특정 상황에서 프로그램은 비정상적으로 종료되지는 않으나, **값이 부정확**하게 계산된다.

### Task1 결함 유발 입력값 찾기 (Bug Hunting)

제공된 코드가 논리적 결함으로 인해 비정상적인 값을 출력하도록 유발하는 입력을 찾아 제출해야 한다.

### Task2 결함 코드 수정하기 (Patch)

**Task1**에서 발견하거나 추정한 결함을 해결하기 위해 **제공된 코드 파일을 수정**해야 한다.  
목표는 제한 범위 내 모든 입력에 대해 **정확한 값**을 계산하여 출력하도록 수정해야 한다.

---