import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class MazeModel {
    private final int N;
    private final int[][] graph;
    private final boolean[][] visit;
    private final Coord[][] backtrack;
    private final Coord start;
    private Coord endCoord = null;

    public MazeModel(int N, int[][] graph, Coord start) {
        this.N = N;
        this.graph = graph;
        this.start = start;
        this.visit = new boolean[N][N];
        this.backtrack = new Coord[N][N];
    }

    public boolean solveMaze() {
        if (start == null) return false;

        Queue<Coord> q = new LinkedList<>();
        q.add(start);

        visit[start.y()][start.x()] = true;
        backtrack[start.y()][start.x()] = null;

        int[] dy = {1, -1, 0, 0};
        int[] dx = {0, 0, 1, -1};

        while (!q.isEmpty()) {
            Coord cord = q.poll();

            if (cord.x() == 0 || cord.y() == 0 || cord.x() == N - 1 || cord.y() == N - 1) {
                endCoord = cord;
                return true;
            }

            for (int i = 0; i < 4; i++) {
                int ny = cord.y() + dy[i];
                int nx = cord.x() + dx[i];
                if (!inRange(ny, nx)) continue;
                if (graph[ny][nx] == 1) continue;
                if (visit[ny][nx]) continue;

                Coord next = new Coord(ny, nx);
                visit[ny][nx] = true;
                backtrack[ny][nx] = cord;
                q.add(next);
            }
        }
        return false;
    }

    public List<Coord> getPath() {
        List<Coord> path = new LinkedList<>();
        Coord current = endCoord;
        path.add(0, current);
        do {
            current = backtrack[current.y()][current.x()];
            path.add(0, current);
        } while (current != start);
        return path;
    }

    private boolean inRange(int y, int x) {
        return 0 <= x && x < N && 0 <= y && y < N;
    }
}
