import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class MazeController {
    private final Scanner scanner;
    private MazeModel model;
    private final ConsoleView view;

    public MazeController(Scanner scanner, ConsoleView view) {
        this.scanner = scanner;
        this.view = view;
    }

    private void validateInput(int N, List<Integer> flatData, Coord start, int startCount) {
        if (N < 5 || N > 100) {
            view.displayError("[Error] 유효한 입력이 아닙니다.");
            System.exit(1);
        }

        if (flatData.size() != N * N) {
            view.displayError("[Error] 유효한 입력이 아닙니다.");
            System.exit(1);
        }

        if (startCount != 1) {
            view.displayError("[Error] 유효한 입력이 아닙니다.");
            System.exit(1);
        }

        for (int block : flatData) {
            if (block < 0 || block > 2) {
                view.displayError("[Error] 유효한 입력이 아닙니다.");
                System.exit(1);
            }
        }
    }

    private void initializeModel() {
        if (!scanner.hasNextInt()) {
            view.displayError("[Error] 유효한 입력이 아닙니다.");
            System.exit(1);
        }

        int N = scanner.nextInt();
        List<Integer> flatData = new ArrayList<>();
        int[][] graph = new int[N][N];
        Coord start = null;
        int startCount = 0;

        for (int i = 0; i < N * N; i++) {
            if (!scanner.hasNextInt()) break;

            int block = scanner.nextInt();
            flatData.add(block);

            if (block == 2) {
                startCount++;
                if (start == null) {
                    start = new Coord(i / N, i % N);
                }
                graph[i / N][i % N] = 0;
            } else {
                graph[i / N][i % N] = block;
            }
        }

        validateInput(N, flatData, start, startCount);

        this.model = new MazeModel(N, graph, start);
    }

    public void run() {
        initializeModel();

        boolean solved = model.solveMaze();

        if (solved) {
            List<Coord> path = model.getPath();
            view.displaySuccess(path);
        } else {
            view.displayFailure();
        }
    }
}
