# MAZE 

## 1. 문제

### 1.1 문제 상황
제공된 코드는 BFS(너비 우선 탐색)를 사용하여 $N\times N$ 크기의 미로에서 시작점(**2**)부터 미로의 경계($0$행, $N-1$행, $0$열, $N-1$열) 중 하나로 탈출하는 **최단 경로**를 찾는 프로그램이다. 미로에서 **0**은 이동할 수 있는 칸을 나타내고, **1**은 이동할 수 없는 칸을 나타낸다. 한 칸에서 이동할 수 있는 칸은 상하좌우로 인접한 칸이다. 탐색에 성공하면 해당 경로를 역추적하여 시작점부터 탈출점까지 순서대로 출력하도록 설계되어 있다.

그러나 제공된 코드에는 결함이 존재한다. 여러분은 그 이유를 찾고 수정하여 프로그램을 완성하자.

### 1.2 입력
첫째 줄에 정수 $N(5 \leq N \leq 100)$이 주어진다.  
둘째 줄부터 $N$개의 줄에 걸쳐 각 줄에 미로의 칸에 해당하는 $N$개의 정수를 공백으로 구분되어 주어진다.  
미로의 시작점은 유일하게 존재한다.  

### 1.3 출력
미로를 탈출 할 수 없다면, 첫째 줄에 `Fail`을 출력한다.  
미로를 탈출 할 수 있다면, 첫째 줄에 `Success`를 출력하고 둘째 줄부터 시작점부터 탈출점까지의 순서로 경로의 좌표를 한 줄에 하나씩 출력한다.  
스폐셜 저지가 아님에 주의하여 제공된 코드와 동일한 방식으로 출력한다.

### 1.4 입력 예시
```
5
1 1 1 1 1
1 2 0 0 1
1 1 1 0 1
0 0 0 0 1
1 1 1 1 1
```

### 1.5 출력 예시
```
Success
1 1
1 2
1 3
2 3
3 3
3 2
3 1
3 0
```

---

## 2. 평가 테스크

제공된 코드에는 **실행 중 오류**가 내장되어 있다.  

### Task1 결함 유발 입력값 찾기 (Bug Hunting)

제공된 코드가 실행 중 오류로 인해 비정상적인 프로그램 종료를 유발하는 입력을 찾아 제출해야 한다.

### Task2 결함 코드 수정하기 (Patch)

**Task1**에서 발견하거나 추정한 결함을 해결하기 위해 **제공된 코드 파일을 수정**해야 한다.  
목표는 제한 범위 내 모든 입력에 대해 **정확한 값**을 계산하여 출력하도록 수정해야 한다.

-----

## 3. 참고

### 3.1 디자인 패턴
코드는 **MVC(Model-View-Controller) 패턴**을 기반으로 구조화되어 있으며, 각 컴포넌트(`MazeModel`, `MazeController`)는 특정 책임을 가진다.

---