import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;

public class Main {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("[Error] 유효한 입력이 아닙니다.");
            System.exit(1);
        }

        Scanner sc;
        try {
            sc = new Scanner(new File(args[0]));
        } catch (FileNotFoundException e) {
            System.err.println("[Error] 유효한 입력이 아닙니다.");
            System.exit(1);
            return;
        }

        ConsoleView view = new ConsoleView();
        MazeController controller = new MazeController(sc, view);

        controller.run();
        sc.close();
    }
}
