import java.util.List;
import java.util.stream.Collectors;

public class ConsoleView {

    public void displaySuccess(List<Coord> path) {
        System.out.println("Success");

        String pathOutput = path.stream()
                .map(Coord::toString)
                .collect(Collectors.joining("\n"));
        System.out.println(pathOutput);
    }

    public void displayFailure() {
        System.out.println("Fail");
    }

    public void displayError(String message) {
        System.err.println("--- FATAL ERROR ---");
        System.err.println(message);
        System.err.println("-------------------");
    }
}
