#include <stdio.h>
#include <stdlib.h>

void swap(int *a, int *b) {
    *a = *a ^ *b;
    *b = *a ^ *b;
    *a = *a ^ *b;
}

void selectionSort(int arr[], int n) {
    for (int i = 0; i < n - 1; ++i) {
        int m = i;
        for (int j = i + 1; j < n; ++j) {
            if (arr[j] < arr[m]) {
                m = j;
            }
        }
        swap(&arr[i], &arr[m]);
    }
}

void printArray(const int arr[], int size) {
    for (int i = 0; i < size; ++i) {
        printf("%d%s", arr[i], (i < size - 1 ? " " : "\n"));
    }
}

int main(int argc, char *argv[]) {
    if (argc < 2) {
        fprintf(stderr, "Usage: %s <filename>\n", argv[0]);
        return 1;
    }

    FILE *fp = fopen(argv[1], "r");
    if (fp == NULL) {
        fprintf(stderr, "[Error] 유효한 입력이 아닙니다.\n");
        return 1;
    }

    int N;
    if (fscanf(fp, "%d", &N) != 1 || N <= 0 || N > 100) {
        fprintf(stderr, "[Error] 유효한 입력이 아닙니다.\n");
        fclose(fp);
        return 1;
    }

    int *arr = (int *)malloc(N * sizeof(int));
    if (arr == NULL) {
        fprintf(stderr, "[Error] 유효한 입력이 아닙니다.\n");
        fclose(fp);
        return 1;
    }

    for (int i = 0; i < N; i++) {
        if (fscanf(fp, "%d", &arr[i]) != 1 || arr[i] < -1000000 || arr[i] > 1000000) {
            fprintf(stderr, "[Error] 유효한 입력이 아닙니다.\n");
            free(arr);
            fclose(fp);
            return 1;
        }
    }

    int extra;
    if (fscanf(fp, "%d", &extra) == 1) {
        fprintf(stderr, "[Error] 유효한 입력이 아닙니다.\n");
        free(arr);
        fclose(fp);
        return 1;
    }

    fclose(fp);

    selectionSort(arr, N);

    printArray(arr, N);

    free(arr);
    return 0;
}