import sys
import re
from settings import ALPHABET_SIZE
from cipher_strategies import CaesarEncodeStrategy, CaesarDecodeStrategy
from context import CipherContext

def main(input_filename: str):
    try:
        with open(input_filename, 'r', encoding='utf-8') as f:
            lines = [line.strip() for line in f if line.strip()]
            
            if len(lines) != 3:
                print("[Error] 유효한 입력이 아닙니다.")
                return

            mode = lines[0].upper()
            
            try:
                shift_n = int(lines[1])
                if abs(shift_n) > 100: raise ValueError
            except ValueError:
                print("[Error] 유효한 입력이 아닙니다.")
                return

            input_s = lines[2]
            if len(input_s) == 0 or len(input_s) > 100:
                print("[Error] 유효한 입력이 아닙니다.")
                return
            
            if not re.match(r'^[a-zA-Z0-9.!?]+$', input_s):
                print("[Error] 유효한 입력이 아닙니다.")
                return

    except FileNotFoundError:
        print("[Error] 유효한 입력이 아닙니다.")
        return
    
    if mode == "ENCODE":
        strategy = CaesarEncodeStrategy()
        action_name = "암호화"
    elif mode == "DECODE":
        strategy = CaesarDecodeStrategy()
        action_name = "복호화"
    else:
        print("[Error] 유효한 입력이 아닙니다.")
        return

    context = CipherContext(strategy)
    output_s = context.process_data(input_s, shift_n)

    print(f"\n[실행 정보]")
    print(f"모드: {mode}")
    print(f"이동 거리 (N): {shift_n}")
    print(f"원본 문자열 (S): '{input_s}'")
    print(f"{action_name}된 문자열: '{output_s}'\n")

if __name__ == "__main__":
    filename = 'sample.in'
    if len(sys.argv) > 1:
        filename = sys.argv[1]
        
    main(filename)