from cipher_strategies import CaesarCipherStrategy

class CipherContext:
    def __init__(self, strategy: CaesarCipherStrategy):
        self._strategy = strategy

    def set_strategy(self, strategy: CaesarCipherStrategy):
        self._strategy = strategy

    def process_data(self, text: str, shift: int) -> str:
        strategy_name = self._strategy.__class__.__name__.replace('Strategy', '')
        print(f"--- [MODE: {strategy_name}] ---")
        return self._strategy.execute(text, shift)