from abc import ABC, abstractmethod
from settings import ALPHABET_CUSTOM, ALPHABET_SIZE

class CaesarCipherStrategy(ABC):
    @abstractmethod
    def execute(self, text: str, shift: int) -> str:
        pass

def _process_caesar_custom(text: str, shift: int) -> str:
    result = ""
    
    char_to_index = {char: i for i, char in enumerate(ALPHABET_CUSTOM)}
    
    for char in text:
        if char in char_to_index:
            current_index = char_to_index[char]
            new_index = current_index + shift
            result += ALPHABET_CUSTOM[new_index]
        else:
            result += char
            
    return result

class CaesarEncodeStrategy(CaesarCipherStrategy):
    def execute(self, text: str, shift: int) -> str:
        return _process_caesar_custom(text, shift)

class CaesarDecodeStrategy(CaesarCipherStrategy):
    def execute(self, text: str, shift: int) -> str:
        return _process_caesar_custom(text, -shift)