# CAESAR 

## 1. 문제

### 1.1 문제 상황
로마의 지도자 율리우스 카이사르(Julius Caesar)는 개인 서신을 작성할 때 간단한 암호 기법을 사용한 것으로 알려져 있다. 로마의 역사가 수에토니우스의 기록에 따르면, 카이사르는 글자를 일정한 수($N$)만큼 뒤로 미는 방식의 치환 암호를 사용했으며, 특히 $N=3$을 적용한 사례가 유명하다. 이 암호는 오늘날 `카이사르 암호` 또는 `시저 암호` 로 불리며, 구조는 단순하지만 당시에는 암호화 개념이 널리 알려지지 않아 기본적인 은밀성 확보에는 충분했다. 이러한 기법은 고대 문헌에 명확히 기록된 가장 초기의 암호화 방식 중 하나로 평가되며, 이후 발전한 암호학의 기초가 되었다.

제공된 코드는 커스텀 Caesar 암호화/복호화 유틸리티 프로그램이다. 이 프로그램은 지정된 모드(`ENCODE` 또는 `DECODE`)와 이동 거리($N$)를 적용하여 입력 문자열을 변환한다.
그러나 제공된 코드에는 결함이 존재한다. 여러분은 그 이유를 찾고 수정하여 프로그램을 완성하자.

### 1.2 입력
첫째 줄에 모드(`ENCODE` 또는 `DECODE`)가 주어진다.  
둘째 줄에 정수 이동거리 $N$이 주어진다. $(|N| \leq 100)$  
셋째 줄에 변환할 문자열 $S$가 주어진다. $(1 \leq |S| \leq 100,\ S ∈ [a-zA-Z0-9.!?]+)$  

### 1.3 출력
출력은 예시와 같은 형식이다.  
상세한 출력은 **main.py** 파일을 참고한다.

### 1.4 입력 예시
```
ENCODE
3
HelloWorld!
```

### 1.5 출력 예시
```
--- [MODE: CaesarEncode] ---

[실행 정보]
모드: ENCODE
이동 거리 (N): 3
원본 문자열 (S): 'HelloWorld!'
암호화된 문자열: 'EhoorTruog2'
```

---

## 2. 평가 테스크

제공된 코드에는 **실행 중 오류**가 내장되어 있다.  

### Task1 결함 유발 입력값 찾기 (Bug Hunting)

제공된 코드가 실행 중 오류로 인해 비정상적인 프로그램 종료를 유발하는 입력을 찾아 제출해야 한다.

### Task2 결함 코드 수정하기 (Patch)

**Task1**에서 발견하거나 추정한 결함을 해결하기 위해 **제공된 코드 파일을 수정**해야 한다.  
목표는 제한 범위 내 모든 입력에 대해 **정확한 값**을 계산하여 출력하도록 수정해야 한다.

-----

## 3. 참고

### 3.1 Caesar 암호 체계
알파벳을 일정한 거리만큼 평행 이동하여 암호문을 만드는 단순 치환 암호이다. 예를 들어 키 값이 3이면, 평문에서 A는 D로, B는 E로 치환된다. 알파벳의 끝에 도달하면 다시 처음으로 순환하여 매핑한다. 복호화는 반대로 같은 거리만큼 이동해 원래 문자를 복원하는 방식으로 이루어진다.

### 3.2 디자인 패턴
프로그램은 **전략(Strategy) 패턴**을 사용하여 인코딩/디코딩 로직을 분리하고, `CipherContext`를 통해 전략을 적용한다.
  * `main.py`: 실행 진입점
  * `settings.py`: 알파벳 크기 등 상수 정의
  * `cipher_strategies.py`: `CaesarEncodeStrategy`, `CaesarDecodeStrategy` 등의 핵심 로직 구현
  * `context.py`: `CipherContext` 구현

---