# Practice. SALES

## 1. 문제

### 1.1 문제 상황  
최근 판매 실적이 부진한 ANA 마트에서는 새로운 방식의 마케팅에 도전했다.
이번 마케팅의 최종 책임자인 준혁이는 마케팅 효과 분석 보고서를 작성하기 위해 프로그램을 작성했다. 해당 프로그램은 $N$개의 상품의 마케팅 실시 전 판매 실적과 실시 후 판매 실적을 입력받아, 총 판매 실적, 평균 판매량 그리고 변화율을 계산하여 출력한다. 이들은 마케팅 투자 대비 효과(ROI)를 판단하는 중요한 지표로 활용될 예정이다. 

준혁이가 열심히 작성한 프로그램은 결함으로 인해 ANA 마트의 사장인 현석이에게 리젝됐다. 여러분은 그 이유를 찾고 수정하여 준혁이를 도와주자.

### 1.2 입력  
정수 $N$이 주어진다. $(0 < N \leq 100)$  
이어서 마케팅 실시 전 판매 실적 $N$개의 정수를 공백으로 구분되어 주어진다.  
이어서 마케팅 실시 후 판매 실적 $N$개의 정수를 공백으로 구분되어 주어진다.  
각 판매 실적은 $1$부터 $10\ 000$ 사이의 정수이다.  
상세한 입력 제한은 **Main.java** 파일을 참고한다.

### 1.3 출력
출력은 예시와 같은 형식이다.  
상세한 출력은 **Main.java** 파일을 참고한다.

### 1.4 입력 예시
```
2
1 3
2 6
```

### 1.5 출력 예시
```
======================================
마케팅 실시 전후 판매 실적 분석 결과
======================================
상품 개수 (N): 2 개
실시 전 총 판매 실적: 4
실시 후 판매 실적: 8
--------------------------------------
실시 전 평균 판매량: 2.00
실시 후 평균 판매량: 4.00
--------------------------------------
실시 전 대비 실시 후 변화율: 100%
======================================
```

---

## 2. 평가 테스크

제공된 코드에는 **논리적 결함**이 내장되어 있다.  
특정 상황에서 프로그램은 비정상적으로 종료되지는 않으나, **값이 부정확**하게 계산된다.

### Task1 결함 유발 입력값 찾기 (Bug Hunting)

제공된 코드가 논리적 결함으로 인해 비정상적인 값을 출력하도록 유발하는 입력을 찾아 제출해야 한다.

### Task2 결함 코드 수정하기 (Patch)

**Task1**에서 발견하거나 추정한 결함을 해결하기 위해 **제공된 코드 파일을 수정**해야 한다.  
목표는 제한 범위 내 모든 입력에 대해 **정확한 값**을 계산하여 출력하도록 수정해야 한다.

---