import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import java.util.List;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class Main {

    public static float calculateChangeRate(long sumB, long sumF) {
        if (sumB == 0) {
            return 0.0f;
        }

        float rate = (sumF - sumB) / sumB * 100.0f;
        
        return rate;
    }

    public static long sumList(List<Integer> list) {
        long sum = 0;
        for (int val : list) {
            sum += val;
        }
        return sum;
    }

    public static float calculateAverage(long sum, int count) {
        if (count == 0) return 0.0f;
        return (float) sum / count;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: java Main <filename>");
            System.exit(1);
        }

        Scanner scanner;
        try {
            scanner = new Scanner(new File(args[0]));
        } catch (FileNotFoundException e) {
            System.err.println("Error: File not found - " + args[0]);
            System.exit(1);
            return;
        }

        if (!scanner.hasNextInt()) {
            System.err.println("Error: 실적 입력 오류");
            scanner.close();
            return;
        }
        int N = scanner.nextInt();
        if (!(0 < N && N <= 100)) {
            System.err.println("Error: 실적 입력 오류");
            scanner.close();
            return;
        }
        
        List<Integer> salesBefore = new ArrayList<>();
        for (int i = 0; i < N; i++) {
            if (!scanner.hasNextInt()) {
                System.err.println("Error: 실적 입력 오류.");
                scanner.close();
                return;
            }
            int item = scanner.nextInt();
            if (1 <= item && item <= 10000) {
                salesBefore.add(item);
            } else {
                System.err.println("Error: 실적 입력 오류.");
                scanner.close();
                return;
            }
        }

        List<Integer> salesAfter = new ArrayList<>();
        for (int i = 0; i < N; i++) {
            if (!scanner.hasNextInt()) {
                System.err.println("Error: 실적 입력 오류.");
                scanner.close();
                return;
            }
            int item = scanner.nextInt();
            if (1 <= item && item <= 10000) {
                salesAfter.add(item);
            } else {
                System.err.println("Error: 실적 입력 오류.");
                scanner.close();
                return;
            }
        }
        
        long sumB = sumList(salesBefore);
        long sumF = sumList(salesAfter);
        
        float avgB = calculateAverage(sumB, N);
        float avgF = calculateAverage(sumF, N);
        
        float changeRate = calculateChangeRate(sumB, sumF);

        System.out.println("\n======================================");
        System.out.println("마케팅 실시 전후 판매 실적 분석 결과");
        System.out.println("======================================");
        System.out.printf("상품 개수 (N): %d 개\n", N);
        System.out.printf("실시 전 총 판매 실적: %d\n", sumB);
        System.out.printf("실시 후 총 판매 실적: %d\n", sumF);
        System.out.println("--------------------------------------");
        System.out.printf("실시 전 평균 판매량: %.2f\n", avgB);
        System.out.printf("실시 후 평균 판매량: %.2f\n", avgF);
        System.out.println("--------------------------------------");
        System.out.printf("실시 전 대비 실시 후 변화율: %.0f%%\n", changeRate);
        System.out.println("======================================");
        
        scanner.close();
    }
}